  'Control program for LCR Reference Box
  '4x TPIC595 controlling 30 relays
'TODO: add TPIC interface
  
  OPTION EXPLICIT
  OPTION AUTORUN ON
  OPTION BASE 0
  'set custom colours here
  CONST C.BACKGROUND=RGB(0,0,0)
  CONST C.FOREGROUND=RGB(255,255,255)
  CONST C.SHADED=RGB(128,128,128)
  CONST C.LOGO=RGB(255,192,0)
  CONST C.BUTTON=RGB(0,255,255)
  CONST C.BUTTONFADE=RGB(0,128,128)
  CONST C.BUTTONBG=RGB(64,64,64)
  CONST C.RUN=RGB(0,192,0)
  CONST C.STOP=RGB(192,0,0)
  CONST BUTTONMAX=20
  'Boot screen
  cls(C.BACKGROUND)
  TEXT 240,0," ",CT,9,2,C.LOGO,C.BACKGROUND 'logo is 240x93 => 480x186
  TEXT 240,192,"Programmable",CT,8,2,C.FOREGROUND,C.BACKGROUND
  TEXT 240,256,"LCR Box",CT,8,2,C.FOREGROUND,C.BACKGROUND
  
  'OUTPUT values and relay images, all values are floats
  CONST RCOUNT=42
  DIM RVALUES(RCOUNT)=(1,1.5,2.2,3.3,4.7,6.8,10,15,22,33,47,68,100,150,220,330,470,680,1000,1500,2200,3300,4700,6800,10000,15000,22000,33000,47000,68000,100000,150000,220000,330000,470000,680000,1000000,1500000,2200000,3300000,4700000,6800000,10000000)
  DIM INTEGER RIMAGES(RCOUNT)=(1038,12,395,10,2057,9,3208,2056,9288,1032,584,72,8840,520,392,136,16648,264,32776,16392,4104,8200,6,4,67,2,38913,1,3072,2048,33856,1024,576,64,768,512,128,256,36864,32768,16384,4096,8192)
  CONST CCOUNT=18
  DIM CVALUES(CCOUNT)=(0.00000000001,0.000000000022,0.000000000047,0.0000000001,0.00000000022,0.00000000047,0.000000001,0.0000000022,0.0000000047,0.00000001,0.000000022,0.000000047,0.0000001,0.00000022,0.00000047,0.000001,0.0000022,0.0000047,0.00001)
  DIM INTEGER CIMAGES(CCOUNT)=(0,64,32,1,4,2,256,16384,1024,4096,192,160,129,132,130,384,16512,1152,4224)
  CONST LCOUNT=9
  DIM LVALUES(LCOUNT)=(0.0000001,0.00000033,0.000001,0.0000033,0.00001,0.000033,0.0001,0.00033,0.001,0.0033)
  DIM INTEGER LIMAGES(LCOUNT)=(24,32784,528,2064,8208,8,32768,512,2048,8192)
  
  'these are indexes into the above arrays to limit the range, default to full range
  DIM INTEGER RMIN,RMAX,CMIN,CMAX,LMIN,LMAX,RLAST,RCURRENT,CLAST,CCURRENT,LLAST,LCURRENT
  RMIN=0
  RMAX=RCOUNT
  CMIN=0
  CMAX=CCOUNT
  LMIN=0
  LMAX=LCOUNT
  'high R
  RCURRENT=RCOUNT
  'low C
  CCURRENT=0
  CLAST=CCURRENT
  'High L
  LCURRENT=LCOUNT
  LLAST=LCURRENT
  Dim Integer key_coord(BUTTONMAX, 5)
  Dim String key_caption(BUTTONMAX)
  DIM INTEGER BPRESS, OLDBPRESS
  DIM INTEGER RRAMP,CRAMP,LRAMP
  DIM INTEGER RMODE,CMODE,LMODE
  DIM INTEGER RLOOP,CLOOP,LLOOP
  CONST MODEUP=1
  CONST MODEDOWN=2
  CONST MODESAWTOOTHUP=3    'need to differentiate
  CONST MODESAWTOOTHDOWN=4
  RRAMP=0
  CRAMP=0
  LRAMP=0
  RMODE=MODEUP
  CMODE=MODEUP
  LMODE=MODEUP
  RLOOP=0
  CLOOP=0
  LLOOP=0
  DIM INTEGER TMODE,FMODE
  CONST RC=1
  CONST RL=2
  CONST LC=3
  TMODE=RC
  FMODE=0
  CONST RAMPMIN=0.1
  CONST RAMPSTEP=0.1
  CONST RAMPMAX=10
  DIM FLOAT RAMPINTERVAL,LASTRAMPINTERVAL  'in seconds
  RAMPINTERVAL= RAMPMIN
  LASTRAMPINTERVAL=RAMPINTERVAL   'store variable for slider
  'IO PIN allocations
  CONST SRDATA=5
  CONST SRCLK=9
  CONST LATCHENABLE=21
  CONST RRCK=10
  CONST LCRCK=22
  'set up outputs
  RELAYINIT
  UPDATER
  UPDATELC
  'main screen, draw, then update as necessary
  VAR RESTORE
  RLAST=RCURRENT
  CLAST=CCURRENT
  LLAST=LCURRENT
  PAUSE 500
  TIMER=0 'use this for ramp stepping
DRAWMAIN:
  MAINDISPLAYINIT
MAIN:
  BPRESS=CheckButtonPress(0,9)
  IF BPRESS>-1 THEN
    CheckButtonRelease BPRESS
    if BPRESS=0 THEN GOTO DRAWSETTINGS
    if BPRESS=1 AND RCURRENT<RMAX THEN RCURRENT=RCURRENT+1
    if BPRESS=2 AND RCURRENT>RMIN THEN RCURRENT=RCURRENT-1
    if BPRESS=3 AND CCURRENT<CMAX THEN CCURRENT=CCURRENT+1
    if BPRESS=4 AND CCURRENT>CMIN THEN CCURRENT=CCURRENT-1
    if BPRESS=5 AND LCURRENT<LMAX THEN LCURRENT=LCURRENT+1
    if BPRESS=6 AND LCURRENT>LMIN THEN LCURRENT=LCURRENT-1
    if BPRESS=7 THEN
      IF RRAMP <> 0 THEN
        RRAMP=0
      ELSE
        RRAMP=RMODE
        IF (RRAMP=MODEUP) AND (RCURRENT=RMAX) THEN RCURRENT=RMIN  'loop to start if already at end when triggered
        IF (RRAMP=MODEDOWN) AND (RCURRENT=RMIN) THEN RCURRENT=RMAX  'loop to start if already at end when triggered
        IF (RRAMP=MODESAWTOOTHUP) AND (RCURRENT=RMAX) THEN RRAMP=MODESAWTOOTHDOWN 'ramp down if at max
      ENDIF
    ENDIF
    if BPRESS=8 THEN
      IF CRAMP <> 0 THEN
        CRAMP=0
      ELSE
        CRAMP=CMODE
        IF (CRAMP=MODEUP) AND (CCURRENT=CMAX) THEN CCURRENT=CMIN  'loop to start if already at end when triggered
        IF (CRAMP=MODEDOWN) AND (CCURRENT=CMIN) THEN CCURRENT=CMAX  'loop to start if already at end when triggered
        IF (CRAMP=MODESAWTOOTHUP) AND (CCURRENT=CMAX) THEN CRAMP=MODESAWTOOTHDOWN 'ramp down if at max
      ENDIF
    ENDIF
    if BPRESS=9 THEN
      IF LRAMP <> 0 THEN
        LRAMP=0
      ELSE
        LRAMP=LMODE
        IF (LRAMP=MODEUP) AND (LCURRENT=LMAX) THEN LCURRENT=LMIN  'loop to start if already at end when triggered
        IF (LRAMP=MODEDOWN) AND (LCURRENT=LMIN) THEN LCURRENT=LMAX  'loop to start if already at end when triggered
        IF (LRAMP=MODESAWTOOTHUP) AND (LCURRENT=LMAX) THEN LRAMP=MODESAWTOOTHDOWN 'ramp down if at max
      ENDIF
    ENDIF
    IF (BPRESS=7) OR (BPRESS=8) OR (BPRESS=9) THEN DRAWRAMPBUTTONS  'update after changes
  END IF
  'simple slider control, touch over current value
  CHECKSLIDERS
  CHECKTIMER
ENDIF
'check for changes and update outputs and display
if RCURRENT <> RLAST THEN MAINRBUTTONS : DRAWRSLIDER : DRAWFT : UPDATER : TEXTUNITS RVALUES(RCURRENT),384,55,3,"`"  'ohms symbol
IF CCURRENT <> CLAST THEN MAINCBUTTONS : DRAWCSLIDER : DRAWFT : TEXTUNITS CVALUES(CCURRENT),384,145,3,"F"
IF LCURRENT <> LLAST THEN MAINLBUTTONS : DRAWLSLIDER : DRAWFT : TEXTUNITS LVALUES(LCURRENT),384,235,3,"H"
IF (CCURRENT <> CLAST) OR (LCURRENT <> LLAST) THEN UPDATELC
GOTO MAIN

SUB CHECKTIMER
LOCAL INTEGER RTEMP,CTEMP,LTEMP   ''local flags to update buttons on change
RTEMP=RRAMP
CTEMP=CRAMP
LTEMP=LRAMP
IF TIMER > RAMPINTERVAL*1000 THEN
  'check for R
  IF RRAMP=MODEUP THEN
    IF RCURRENT<RMAX THEN
      RCURRENT=RCURRENT+1
    ELSE
      IF RLOOP <>0 THEN RCURRENT = RMIN ELSE RRAMP=0
    ENDIF
  ENDIF
  IF RRAMP=MODEDOWN THEN
    IF RCURRENT>RMIN THEN
      RCURRENT=RCURRENT-1
    ELSE
      IF RLOOP <>0 THEN RCURRENT = RMAX ELSE RRAMP=0
    ENDIF
  ENDIF
  IF RRAMP=MODESAWTOOTHUP THEN
    IF RCURRENT<RMAX THEN
      RCURRENT=RCURRENT+1
    ELSE
      IF RLOOP <>0 THEN RRAMP = MODESAWTOOTHDOWN ELSE RRAMP=0
    ENDIF
  ENDIF
  IF RRAMP=MODESAWTOOTHDOWN THEN
    IF RCURRENT>RMIN THEN
      RCURRENT=RCURRENT-1
    ELSE
      IF RLOOP <>0 THEN RRAMP = MODESAWTOOTHUP ELSE RRAMP=0
    ENDIF
  ENDIF
  'check for C
  IF CRAMP=MODEUP THEN
    IF CCURRENT<CMAX THEN
      CCURRENT=CCURRENT+1
    ELSE
      IF CLOOP <>0 THEN CCURRENT = CMIN ELSE CRAMP=0
    ENDIF
  ENDIF
  IF CRAMP=MODEDOWN THEN
    IF CCURRENT>CMIN THEN
      CCURRENT=CCURRENT-1
    ELSE
      IF CLOOP <>0 THEN CCURRENT = CMAX ELSE CRAMP=0
    ENDIF
  ENDIF
  IF CRAMP=MODESAWTOOTHUP THEN
    IF CCURRENT<CMAX THEN
      CCURRENT=CCURRENT+1
    ELSE
      IF CLOOP <>0 THEN CRAMP = MODESAWTOOTHDOWN ELSE CRAMP=0
    ENDIF
  ENDIF
  IF CRAMP=MODESAWTOOTHDOWN THEN
    IF CCURRENT>CMIN THEN
      CCURRENT=CCURRENT-1
    ELSE
      IF CLOOP <>0 THEN CRAMP = MODESAWTOOTHUP ELSE CRAMP=0
    ENDIF
  ENDIF
  'check for L
  IF LRAMP=MODEUP THEN
    IF LCURRENT<LMAX THEN
      LCURRENT=LCURRENT+1
    ELSE
      IF LLOOP <>0 THEN LCURRENT = LMIN ELSE LRAMP=0
    ENDIF
  ENDIF
  IF LRAMP=MODEDOWN THEN
    IF LCURRENT>LMIN THEN
      LCURRENT=LCURRENT-1
    ELSE
      IF LLOOP <>0 THEN LCURRENT = LMAX ELSE LRAMP=0
    ENDIF
  ENDIF
  IF LRAMP=MODESAWTOOTHUP THEN
    IF LCURRENT<LMAX THEN
      LCURRENT=LCURRENT+1
    ELSE
      IF LLOOP <>0 THEN LRAMP = MODESAWTOOTHDOWN ELSE LRAMP=0
    ENDIF
  ENDIF
  IF LRAMP=MODESAWTOOTHDOWN THEN
    IF LCURRENT>LMIN THEN
      LCURRENT=LCURRENT-1
    ELSE
      IF LLOOP <>0 THEN LRAMP = MODESAWTOOTHUP ELSE LRAMP=0
    ENDIF
  ENDIF
  TIMER=0 'reset for next
  IF (RTEMP <> RRAMP) OR (CTEMP <> CRAMP) OR (LTEMP <> LRAMP) THEN DRAWRAMPBUTTONS
ENDIF
END SUB

SUB CLEARALLBUTTONS   ''invalidate buttons for screen clear
LOCAL INTEGER I
FOR I = 0 TO BUTTONMAX-1
  DrawButton I, 0, 999, 999, 1, 1, 0, ""  ''off screen
NEXT I
END SUB

SUB DOSTORE
VAR SAVE RCURRENT,RMODE,RLOOP,RMIN,RMAX,CCURRENT,CMODE,CLOOP,CMIN,CMAX,LCURRENT,LMODE,LLOOP,LMIN,LMAX,TMODE,FMODE,RAMPINTERVAL
DrawButton 19, 0, 350, 260, 125, 60, C.SHADED, "STORING"   ''redraw button to indicate action done
PAUSE 1000
DrawButton 19, 0, 350, 260, 125, 60, C.BUTTON, "DONE"
PAUSE 1000
DrawButton 19, 0, 350, 260, 125, 60, C.BUTTON, "STORE"     ''return to normal in case of changes
END SUB

DRAWRAMPSETTINGS:
RAMPSETTINGSINIT
RAMPSETTINGS:
BPRESS=CheckButtonPress(0,19)
IF BPRESS>-1 THEN
  CheckButtonRelease BPRESS
  if BPRESS=0 THEN GOTO DRAWMAIN
  if BPRESS=17 THEN GOTO DRAWSETTINGS
  if BPRESS=18 THEN GOTO DRAWDISPSETTINGS
  if BPRESS=19 THEN DOSTORE
  IF BPRESS=1 THEN RMODE=MODEUP
  IF BPRESS=2 THEN RMODE=MODEDOWN
  IF BPRESS=3 THEN RMODE=MODESAWTOOTHUP
  IF BPRESS=4 THEN RLOOP=1
  IF BPRESS=5 THEN RLOOP=0
  IF BPRESS=6 THEN CMODE=MODEUP
  IF BPRESS=7 THEN CMODE=MODEDOWN
  IF BPRESS=8 THEN CMODE=MODESAWTOOTHUP
  IF BPRESS=9 THEN CLOOP=1
  IF BPRESS=10 THEN CLOOP=0
  IF BPRESS=11 THEN LMODE=MODEUP
  IF BPRESS=12 THEN LMODE=MODEDOWN
  IF BPRESS=13 THEN LMODE=MODESAWTOOTHUP
  IF BPRESS=14 THEN LLOOP=1
  IF BPRESS=15 THEN LLOOP=0
  DRAWRAMPVALUES
END IF
GOTO RAMPSETTINGS

SUB RAMPSETTINGSINIT
cls(C.BACKGROUND)
CLEARALLBUTTONS
TEXT 240,8,"Ramp Settings",CT,8,1,C.FOREGROUND,C.BACKGROUND
DrawButton 0, 0, 350, 50, 125, 60, C.BUTTON, "EXIT"
DrawButton 1, 0, 0, 95, 66, 40, C.BUTTON, "UP"
DrawButton 2, 0, 70, 95, 66, 40, C.BUTTON, "DOWN"
DrawButton 3, 0, 140, 95, 66, 40, C.BUTTON, "SAW"
DrawButton 4, 0, 210, 95, 66, 40, C.BUTTON, "LOOP"
DrawButton 5, 0, 280, 95, 66, 40, C.BUTTON, "OFF"
DrawButton 6, 0, 0, 185, 66, 40, C.BUTTON, "UP"
DrawButton 7, 0, 70, 185, 66, 40, C.BUTTON, "DOWN"
DrawButton 8, 0, 140, 185, 66, 40, C.BUTTON, "SAW"
DrawButton 9, 0, 210, 185, 66, 40, C.BUTTON, "LOOP"
DrawButton 10, 0, 280, 185, 66, 40, C.BUTTON, "OFF"
DrawButton 11, 0, 0, 275, 66, 40, C.BUTTON, "UP"
DrawButton 12, 0, 70, 275, 66, 40, C.BUTTON, "DOWN"
DrawButton 13, 0, 140, 275, 66, 40, C.BUTTON, "SAW"
DrawButton 14, 0, 210, 275, 66, 40, C.BUTTON, "LOOP"
DrawButton 15, 0, 280, 275, 66, 40, C.BUTTON, "OFF"
DrawButton 17, 0, 350, 120, 125, 60, C.BUTTON, "LIMIT"
DrawButton 18, 0, 350, 190, 125, 60, C.BUTTON, "DISPLAY"
DrawButton 19, 0, 350, 260, 125, 60, C.BUTTON, "STORE"
DRAWRAMPVALUES
END SUB

SUB DRAWRAMPVALUES
LOCAL STRING TEMPS  ' for compiling message
TEMPS="R:"
If RMODE=MODEUP THEN TEMPS=TEMPS+"SCAN UP,"
If RMODE=MODEDOWN THEN TEMPS=TEMPS+"SCAN DOWN,"
If RMODE=MODESAWTOOTHUP THEN TEMPS=TEMPS+"UP AND DOWN,"
IF RLOOP<>0 THEN TEMPS=TEMPS+"LOOP" ELSE TEMPS=TEMPS+"SINGLE"
TEMPS=LEFT$(TEMPS+"                        ",21)
TEXT 0,58,TEMPS,LT,8,1,C.FOREGROUND,C.BACKGROUND
TEMPS="C:"
If CMODE=MODEUP THEN TEMPS=TEMPS+"SCAN UP,"
If CMODE=MODEDOWN THEN TEMPS=TEMPS+"SCAN DOWN,"
If CMODE=MODESAWTOOTHUP THEN TEMPS=TEMPS+"UP AND DOWN,"
IF CLOOP<>0 THEN TEMPS=TEMPS+"LOOP" ELSE TEMPS=TEMPS+"SINGLE"
TEMPS=LEFT$(TEMPS+"                        ",21)
TEXT 0,148,TEMPS,LT,8,1,C.FOREGROUND,C.BACKGROUND
TEMPS="L:"
If LMODE=MODEUP THEN TEMPS=TEMPS+"SCAN UP,"
If LMODE=MODEDOWN THEN TEMPS=TEMPS+"SCAN DOWN,"
If LMODE=MODESAWTOOTHUP THEN TEMPS=TEMPS+"UP AND DOWN,"
IF LLOOP<>0 THEN TEMPS=TEMPS+"LOOP" ELSE TEMPS=TEMPS+"SINGLE"
TEMPS=LEFT$(TEMPS+"                        ",21)
TEXT 0,238,TEMPS,LT,8,1,C.FOREGROUND,C.BACKGROUND
END SUB

DRAWDISPSETTINGS:
DISPSETTINGSINIT
DISPSETTINGS:
BPRESS=CheckButtonPress(0,19)
IF BPRESS>-1 THEN
  CheckButtonRelease BPRESS
  if BPRESS=0 THEN GOTO DRAWMAIN
  if BPRESS=13 THEN GOTO DRAWSETTINGS
  if BPRESS=14 THEN GOTO DRAWRAMPSETTINGS
  if BPRESS=19 THEN DOSTORE
  IF BPRESS=1 THEN TMODE=RC:DRAWTFDISPLAYSETTING
  IF BPRESS=2 THEN TMODE=RL:DRAWTFDISPLAYSETTING
  IF BPRESS=3 THEN TMODE=LC:DRAWTFDISPLAYSETTING
  IF BPRESS=4 THEN FMODE=1:DRAWTFDISPLAYSETTING
  IF BPRESS=5 THEN FMODE=0:DRAWTFDISPLAYSETTING
END IF
CHECKSTEPTIMESLIDER
GOTO DISPSETTINGS

SUB CHECKSTEPTIMESLIDER
LOCAL INTEGER X,Y
X=Touch(x)
Y=TOUCH(y)
if (X > 15) AND (X<335) THEN
  if (Y>280) AND (Y<319) THEN
    RAMPINTERVAL=RAMPMIN+((X-15)*(RAMPMAX-RAMPMIN))/320
    DRAWRAMPSTEPTIME
  ENDIF
ENDIF

END SUB

SUB DISPSETTINGSINIT
cls(C.BACKGROUND)
CLEARALLBUTTONS
TEXT 240,8,"Display and Ramp Rate Settings",CT,8,1,C.FOREGROUND,C.BACKGROUND
DrawButton 0, 0, 350, 50, 125, 60, C.BUTTON, "EXIT"
DrawButton 13, 0, 350, 120, 125, 60, C.BUTTON, "LIMIT"
DrawButton 14, 0, 350, 190, 125, 60, C.BUTTON, "RAMP"
DrawButton 19, 0, 350, 260, 125, 60, C.BUTTON, "STORE"
DrawButton 1, 0, 0, 140, 90, 40, C.BUTTON, "RC"
DrawButton 2, 0, 125, 140, 90, 40, C.BUTTON, "LR"
DrawButton 3, 0, 250, 140, 90, 40, C.BUTTON, "LC"
DrawButton 4, 0, 0, 185, 160, 40, C.BUTTON, "FREQUENCY"
DrawButton 5, 0, 180, 185, 160, 40, C.BUTTON, "TIME"
TEXT 5,58,"Characteristic T/F:",LT,8,1,C.FOREGROUND,C.BACKGROUND
DRAWTFDISPLAYSETTING
DRAWRAMPSTEPTIME
END SUB

SUB DRAWTFDISPLAYSETTING
LOCAL STRING TEMPS
IF TMODE = RC THEN TEMPS="RC "
IF TMODE = RL THEN TEMPS="LR "
IF TMODE = LC THEN TEMPS="LC "
IF FMODE<>0 THEN TEMPS=TEMPS+"FREQUENCY" ELSE TEMPS=TEMPS+"TIME"
TEMPS=LEFT$(TEMPS+"                        ",21)
TEXT 5,103,TEMPS,LT,8,1,C.FOREGROUND,C.BACKGROUND
END SUB

SUB DRAWRAMPSTEPTIME
LOCAL STRING TEMPS
TEMPS="RAMP STEP: "
TEMPS=TEMPS+STR$(INT(RAMPINTERVAL*10+0.4)/10)+"s"
TEMPS=LEFT$(TEMPS+"                        ",21)
TEXT 5,238,TEMPS,LT,8,1,C.FOREGROUND,C.BACKGROUND
DRAWXSLIDER 15,283,320,30,15+((RAMPINTERVAL-RAMPMIN)*320)/(RAMPMAX-RAMPMIN),15+((LASTRAMPINTERVAL-RAMPMIN)*320)/(RAMPMAX-RAMPMIN)
LASTRAMPINTERVAL=RAMPINTERVAL   'store variable for slider
END SUB

DRAWSETTINGS:
SETTINGSDISPLAYINIT
SETTINGS:
BPRESS=CheckButtonPress(0,19)
IF BPRESS>-1 THEN
  CheckButtonRelease BPRESS
  if BPRESS=0 THEN GOTO DRAWMAIN
  if BPRESS=13 THEN GOTO DRAWRAMPSETTINGS
  if BPRESS=14 THEN GOTO DRAWDISPSETTINGS
  if BPRESS=19 THEN DOSTORE
  'R limits
  if (BPRESS=1) AND (RMAX<RCOUNT) THEN RMAX=RMAX+1
  if (BPRESS=2) AND (RMAX>RMIN) THEN RMAX=RMAX-1
  if (BPRESS=3) AND (RMIN<RMAX) THEN RMIN=RMIN+1
  if (BPRESS=4) AND (RMIN>0) THEN RMIN=RMIN-1
  IF (BPRESS>=1) AND (BPRESS<=4) THEN
    IF RMIN>RMAX THEN RMIN=RMAX     ''shouldn't happen
    IF RCURRENT<RMIN THEN RCURRENT=RMIN
    IF RCURRENT>RMAX THEN RCURRENT=RMAX
    TEXTUNITS RVALUES(RMAX),144,58,1,"`"  'ohms symbol
    TEXTUNITS RVALUES(RMIN),144,103,1,"`"  'ohms symbol
  ENDIF
  'C limits
  if (BPRESS=5) AND (CMAX<CCOUNT) THEN CMAX=CMAX+1
  if (BPRESS=6) AND (CMAX>CMIN) THEN CMAX=CMAX-1
  if (BPRESS=7) AND (CMIN<CMAX) THEN CMIN=CMIN+1
  if (BPRESS=8) AND (CMIN>0) THEN CMIN=CMIN-1
  IF (BPRESS>=5) AND (BPRESS<=8) THEN
    IF CMIN>CMAX THEN CMIN=CMAX     ''shouldn't happen
    IF CCURRENT<CMIN THEN CCURRENT=CMIN
    IF CCURRENT>CMAX THEN CCURRENT=CMAX
    TEXTUNITS CVALUES(CMAX),144,148,1,"F"
    TEXTUNITS CVALUES(CMIN),144,193,1,"F"
  ENDIF
  'L limits
  if (BPRESS=9) AND (LMAX<LCOUNT) THEN LMAX=LMAX+1
  if (BPRESS=10) AND (LMAX>LMIN) THEN LMAX=LMAX-1
  if (BPRESS=11) AND (LMIN<LMAX) THEN LMIN=LMIN+1
  if (BPRESS=12) AND (LMIN>0) THEN LMIN=LMIN-1
  IF (BPRESS>=9) AND (BPRESS<=12) THEN
    IF LMIN>LMAX THEN LMIN=LMAX     ''shouldn't happen
    IF LCURRENT<LMIN THEN LCURRENT=LMIN
    IF LCURRENT>LMAX THEN LCURRENT=LMAX
    TEXTUNITS LVALUES(LMAX),144,238,1,"H"
    TEXTUNITS LVALUES(LMIN),144,283,1,"H"
  ENDIF
  
END IF
GOTO SETTINGS

SUB SETTINGSDISPLAYINIT
cls(C.BACKGROUND)
CLEARALLBUTTONS
TEXT 240,8,"Limit Settings",CT,8,1,C.FOREGROUND,C.BACKGROUND
TEXT 0,58,"R max:",LT,8,1,C.FOREGROUND,C.BACKGROUND
TEXT 0,103,"R min:",LT,8,1,C.FOREGROUND,C.BACKGROUND
TEXT 0,148,"C max:",LT,8,1,C.FOREGROUND,C.BACKGROUND
TEXT 0,193,"C min:",LT,8,1,C.FOREGROUND,C.BACKGROUND
TEXT 0,238,"L max:",LT,8,1,C.FOREGROUND,C.BACKGROUND
TEXT 0,283,"L min:",LT,8,1,C.FOREGROUND,C.BACKGROUND
TEXTUNITS RVALUES(RMAX),144,58,1,"`"  'ohms symbol
TEXTUNITS RVALUES(RMIN),144,103,1,"`"  'ohms symbol
TEXTUNITS CVALUES(CMAX),144,148,1,"F"
TEXTUNITS CVALUES(CMIN),144,193,1,"F"
TEXTUNITS LVALUES(LMAX),144,238,1,"H"
TEXTUNITS LVALUES(LMIN),144,283,1,"H"
DrawButton 0, 0, 350, 50, 125, 60, C.BUTTON, "EXIT"
DrawButton 1, 0, 180, 50, 75, 40, C.BUTTON, "UP"
DrawButton 2, 0, 260, 50, 75, 40, C.BUTTON, "DOWN"
DrawButton 3, 0, 180, 95, 75, 40, C.BUTTON, "UP"
DrawButton 4, 0, 260, 95, 75, 40, C.BUTTON, "DOWN"
DrawButton 5, 0, 180, 140, 75, 40, C.BUTTON, "UP"
DrawButton 6, 0, 260, 140, 75, 40, C.BUTTON, "DOWN"
DrawButton 7, 0, 180, 185, 75, 40, C.BUTTON, "UP"
DrawButton 8, 0, 260, 185, 75, 40, C.BUTTON, "DOWN"
DrawButton 9, 0, 180, 230, 75, 40, C.BUTTON, "UP"
DrawButton 10, 0, 260, 230, 75, 40, C.BUTTON, "DOWN"
DrawButton 11, 0, 180, 275, 75, 40, C.BUTTON, "UP"
DrawButton 12, 0, 260, 275, 75, 40, C.BUTTON, "DOWN"
DrawButton 13, 0, 350, 120, 125, 60, C.BUTTON, "RAMP"
DrawButton 14, 0, 350, 190, 125, 60, C.BUTTON, "DISPLAY"
DrawButton 19, 0, 350, 260, 125, 60, C.BUTTON, "STORE"
END SUB

SUB MAINDISPLAYINIT
cls(C.BACKGROUND)
CLEARALLBUTTONS
TEXT 128,0,"LCR Box",LT,8,2,C.FOREGROUND,C.BACKGROUND
TEXT 00,0," ",LT,10,1,C.LOGO,C.BACKGROUND 'logo is 120x47
DrawButton 0, 0, 362, 4, 108, 32, C.BUTTON, "SETUP"
MAINRBUTTONS    ''separate update routines for speedier refresh
MAINCBUTTONS
MAINLBUTTONS
TEXTUNITS RVALUES(RCURRENT),384,55,3,"`"  'ohms symbol
TEXTUNITS CVALUES(CCURRENT),384,145,3,"F"
TEXTUNITS LVALUES(LCURRENT),384,235,3,"H"
TEXTUNITS RVALUES(RMAX),155,58,1,"`"  'ohms symbol
TEXTUNITS RVALUES(RMIN),155,103,1,"`"  'ohms symbol
TEXTUNITS CVALUES(CMAX),155,148,1,"F"
TEXTUNITS CVALUES(CMIN),155,193,1,"F"
TEXTUNITS LVALUES(LMAX),155,238,1,"H"
TEXTUNITS LVALUES(LMIN),155,283,1,"H"
DRAWRSLIDER
DRAWCSLIDER
DRAWLSLIDER
DRAWRAMPBUTTONS
DRAWFT
END SUB

SUB DRAWFT
LOCAL FLOAT F,T
F=0   'failsafe incase of /0
T=0   'failsafe incase of /0
IF TMODE = RC THEN
  T=RVALUES(RCURRENT)*CVALUES(CCURRENT)
  TEXT 50,58,"RC:",CT,8,1,C.FOREGROUND,C.BACKGROUND
ELSE IF TMODE = RL THEN
  IF RVALUES(RCURRENT)<>0 THEN T= LVALUES(LCURRENT)/RVALUES(RCURRENT)
  TEXT 50,58,"RL:",CT,8,1,C.FOREGROUND,C.BACKGROUND
ELSE  ''asssume LC
  T=LVALUES(LCURRENT)*CVALUES(CCURRENT)
  IF T>0 THEN T=SQR(T) ELSE T=0
  TEXT 50,58,"LC:",CT,8,1,C.FOREGROUND,C.BACKGROUND
ENDIF
IF T <> 0  THEN F = 1/(6.28318530718*T)
IF FMODE=0 THEN
  TEXTUNITS T,50,103,1,"s"
ELSE
  TEXTUNITS F,50,103,1,"Hz"
ENDIF
END SUB

SUB DRAWRAMPBUTTONS
IF RRAMP <> 0 THEN
  DrawButton 7, 0, 0, 185, 100, 40, C.RUN, "STOP R"
ELSE
  DrawButton 7, 0, 0, 185, 100, 40, C.STOP, "RAMP R"
ENDIF
IF CRAMP <> 0 THEN
  DrawButton 8, 0, 0, 230, 100, 40, C.RUN, "STOP C"
ELSE
  DrawButton 8, 0, 0, 230, 100, 40, C.STOP, "RAMP C"
ENDIF
IF LRAMP <> 0 THEN
  DrawButton 9, 0, 0, 275, 100, 40, C.RUN, "STOP L"
ELSE
  DrawButton 9, 0, 0, 275, 100, 40, C.STOP, "RAMP L"
ENDIF
END SUB

SUB MAINRBUTTONS
LOCAL INTEGER BUTTONC
'note that these are the same conditions checked during button presses
if RCURRENT<RMAX THEN BUTTONC=C.BUTTON ELSE BUTTONC=C.BUTTONFADE
DrawButton 1, 0, 195, 50, 40, 40, BUTTONC, "UP"
if RCURRENT>RMIN THEN BUTTONC=C.BUTTON ELSE BUTTONC=C.BUTTONFADE
DrawButton 2, 0, 195, 95, 40, 40, BUTTONC, "DN"
END SUB

SUB MAINCBUTTONS
LOCAL INTEGER BUTTONC
'note that these are the same conditions checked during button presses
if CCURRENT<CMAX THEN BUTTONC=C.BUTTON ELSE BUTTONC=C.BUTTONFADE
DrawButton 3, 0, 195, 140, 40, 40, BUTTONC, "UP"
if CCURRENT>CMIN THEN BUTTONC=C.BUTTON ELSE BUTTONC=C.BUTTONFADE
DrawButton 4, 0, 195, 185, 40, 40, BUTTONC, "DN"
END SUB

SUB MAINLBUTTONS
LOCAL INTEGER BUTTONC
'note that these are the same conditions checked during button presses
if LCURRENT<LMAX THEN BUTTONC=C.BUTTON ELSE BUTTONC=C.BUTTONFADE
DrawButton 5, 0, 195, 230, 40, 40, BUTTONC, "UP"
if LCURRENT>LMIN THEN BUTTONC=C.BUTTON ELSE BUTTONC=C.BUTTONFADE
DrawButton 6, 0, 195, 275, 40, 40, BUTTONC, "DN"
END SUB

SUB DRAWRSLIDER
IF(RMAX <> RMIN) THEN DRAWXSLIDER 250,130,220,9,250+((RCURRENT-RMIN)*220)/(RMAX-RMIN),250+((RLAST-RMIN)*220)/(RMAX-RMIN)
END SUB

SUB DRAWCSLIDER
IF(CMAX <> CMIN) THEN DRAWXSLIDER 250,220,220,9,250+((CCURRENT-CMIN)*220)/(CMAX-CMIN),250+((CLAST-CMIN)*220)/(CMAX-CMIN)
END SUB

SUB DRAWLSLIDER
IF(LMAX <> LMIN) THEN DRAWXSLIDER 250,310,220,9,250+((LCURRENT-LMIN)*220)/(LMAX-LMIN),250+((LLAST-LMIN)*220)/(LMAX-LMIN)
END SUB

SUB DRAWXSLIDER X AS INTEGER, Y AS INTEGER, W AS INTEGER, H AS INTEGER, NEWP AS INTEGER, OLDP AS INTEGER
LINE OLDP,Y,OLDP,Y+H,3,C.BACKGROUND
LINE X,Y,X+W,Y,1,C.SHADED
LINE X,Y+H,X+W,Y+H,1,C.SHADED
LINE X,Y,X,Y+H,1,C.SHADED
LINE X+W,Y,X+W,Y+H,1,C.SHADED
LINE NEWP,Y,NEWP,Y+H,3,C.FOREGROUND
END SUB

'check for linear position and interpolate over current min/max
SUB CHECKSLIDERS
LOCAL INTEGER X,Y
X=Touch(x)
Y=TOUCH(y)
if (X > 250) AND (X<470) THEN
  if (Y>55) AND (Y<140) THEN RCURRENT=RMIN+((X-250)*(RMAX-RMIN))/220
  if (Y>145) AND (Y<230) THEN CCURRENT=CMIN+((X-250)*(CMAX-CMIN))/220
  if (Y>235) AND (Y<320) THEN LCURRENT=LMIN+((X-250)*(LMAX-LMIN))/220
ENDIF
END SUB

'format a text display of a value with engineering units
SUB TEXTUNITS VALUE AS FLOAT, X AS INTEGER, Y AS INTEGER, S AS INTEGER, U AS STRING
LOCAL STRING MULT,NUM
LOCAL FLOAT V
V = VALUE
'multipliers can be G,M,k,(none),m,mu (~), n, p
'PRINT V;" ";
MULT=""
IF V > 999000000 THEN
  MULT="G"
  V = V/1E9
ELSE IF V > 999000 THEN
  MULT="M"
  V = V/1E6
ELSE IF V > 999 THEN
  MULT="k"
  V = V/1E3
ELSE IF V < 999E-12 THEN
  MULT="p"
  V = V*1E12
ELSE IF V < 999E-9 THEN
  MULT="n"
  V = V*1E9
ELSE IF V < 999E-6 THEN
  MULT="~"
  V = V*1E6
ELSE IF V < 999E-3 THEN
  MULT="m"
  V = V*1E3
ENDIF
'text is padded to ensure old value is overwritten
NUM=LEFT$(str$(int(V*10+0.4)/10),3)
IF RIGHT$(NUM,1)="." THEN NUM=LEFT$(NUM,lEN(NUM)-1)
TEXT X,Y,RIGHT$("    "+NUM,3),RT,8,S,C.FOREGROUND,C.BACKGROUND
TEXT X,Y,LEFT$(MULT+U+"   ",LEN(U)+1),LT,8,S,C.FOREGROUND,C.BACKGROUND
'PRINT STR$(V)+MULT+U
END SUB

SUB RELAYINIT
SETPIN SRDATA,DOUT
SETPIN SRCLK,DOUT
SETPIN RRCK,DOUT
SETPIN LCRCK,DOUT
PIN(SRCLK)=0    'clock idles low
PIN(RRCK)=0    'latch idles low
PIN(LCRCK)=0    'latch idles low
SHIFTOUTR(0)    'valid data on outputs
SHIFTOUTLC(0)   'valid data on outputs
SETPIN LATCHENABLE,DOUT   'finally, enable outptuts
PIN(LATCHENABLE)=0
END SUB

SUB UPDATER
LOCAL INTEGER RIMAGE
RIMAGE = RIMAGES(RCURRENT)
SHIFTOUTR(RIMAGE)
'PRINT RIMAGE
RLAST=RCURRENT
END SUB

SUB UPDATELC
LOCAL INTEGER LCIMAGE
LCIMAGE=CIMAGES(CCURRENT)+LIMAGES(LCURRENT)
SHIFTOUTLC(LCIMAGE)
'PRINT LCIMAGE
CLAST=CCURRENT
LLAST=LCURRENT
END SUB

SUB SHIFTOUTR N AS INTEGER
LOCAL INTEGER I,J
J=32768 'MSB first
FOR I = 0 to 15
  IF (J and N)<>0 THEN PIN(SRDATA)=1 ELSE PIN(SRDATA)=0
  PIN(SRCLK)=1    'clock toggle
  PIN(SRCLK)=0    'clock idles low
  J=J\2
NEXT I
PIN(RRCK)=1    'latch toggle
PIN(RRCK)=0    'latch idles low
END SUB

SUB SHIFTOUTLC N AS INTEGER
LOCAL INTEGER I,J
J=32768 'MSB first
FOR I = 0 to 15
  IF (J and N)<>0 THEN PIN(SRDATA)=1 ELSE PIN(SRDATA)=0
  PIN(SRCLK)=1    'clock toggle
  PIN(SRCLK)=0    'clock idles low
  J=J\2
NEXT I
PIN(LCRCK)=1    'latch toggle
PIN(LCRCK)=0    'latch idles low
END SUB

' From SuperClock
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw buttons and get button presses
'
' The subrouting DrawButton will draw a button (normally used when drawing
' the screen for input).
'
' The function CheckButtonPress() will check if a button has been touched.
' If it has it will set it to selected (reverse video) and return with the
' button's number.
'
' The subroutine CheckButtonRelease will wait for the touch to be released
' and will then draw the button as normal.
'
' These routines use the global arrays key_coord() and key_caption() to
' track the coordinates and size of each button and save its caption.
'
' IMPORTANT: These routines set the watchdog to 20 minutes.  If a button
'            has not been pressed within this time the Micromite will
'            restart.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' draw a button
Sub DrawButton n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
Local Integer bc, fc

If mode = 0 Then
  key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
  key_coord(n,4) = c : key_caption(n) = s
EndIf

If mode > 1 Then
  bc = key_coord(n,4) : fc = C.BUTTONBG    ' draw in reverse video if it is being touched
Else
  bc = C.BUTTONBG : fc = key_coord(n,4)    ' a normal (untouched) button
EndIf

RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM,8 ,1, fc, bc
End Sub


' check if a button has been touch and animate the button's image
' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
Local Integer xt, yt, n

CheckButtonPress = -1
If Touch(x) <> -1 Then
  ' we have a touch
  'WatchDog 1200000
  xt = Touch(x)
  yt = Touch(y)
  ' scan the array key_coord() to see if the touch was within the
  ' boundaries of a button
  For n = startn To endn
    If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yt > key_coord(n,1) And yt < key_coord(n,1) + key_coord(n,3) Then
      ' we have a button press
      ' draw the button as pressed
      DrawButton n, 2
      CheckButtonPress = n
      Exit For
    EndIf
  Next n
EndIf
End Function


' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As Integer
' if a button is currently down check if it has been released
Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub
